/*------------------------------------------------------------------------------*
 *	File Name: 	Math.h	     													*
 *	Purpose:	Math function prototypes for calling standard C functions		*
 *				in msvcrt.dll and etc.											*
 *  Creation:	Feb 11, 2001 by CPY												* 
 *  Copyright (c) OriginLab Corp. 2001, 2002, 2003								*
 *	All Rights Reserved															*
 *------------------------------------------------------------------------------*/  
#ifndef _MATH_H
#define _MATH_H


// Origin's internal missing value
#define		NANUM		get_missing_value()

#define		PI			3.1415926535897932384626
#define		Pi	PI
#define		pi	PI


/**@ >Math Functions>Basic*/

// The following functions are implemented in internal.c
// Comments last updated by Frank on 08/08/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:max_(global_function)
*/
double max(double da, double db);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:max_(global_function)
*/
float max(float fa, float fb);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:max_(global_function)
*/
int max(int ia, int ib);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:max_(global_function)
*/
uint max(uint na, uint nb);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:max_(global_function)
*/
short max(short na, short nb);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:max_(global_function)
*/
ushort max(ushort wa, ushort wb);

// Comments last updated by Frank on 08/08/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:min_(global_function)
*/
double min(double da, double db);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:min_(global_function)
*/
float min(float fa, float fb);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:min_(global_function)
*/
int min(int ia, int ib);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:min_(global_function)
*/
uint min(uint na, uint nb);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:min_(global_function)
*/
short min(short na, short nb);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:min_(global_function)
*/
ushort min(ushort wa, ushort wb);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:abs_(global_function)
*/
double	abs(double x);


#pragma dll(@OUTL)


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:pow_(global_function)
*/
double pow(double x, double y);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:rnd_(global_function)
*/
double rnd(int nSeed=0);
// the ran function is implemented in sys_utils.c, so must move to sys_utils.h
//#define ran(_nSeed) rnd(_nSeed)


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:grnd_(global_function)
*/
double grnd(int nSeed=0);	// normally distributed random number with mean=0 and sd=1, nSeed > 0 to set random seed (returns 0)

/**@ >Math Functions>Number and Missing Value and Error Code */

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_missing_value_(global_function)
*/
BOOL	is_missing_value(double x); // return TRUE if given value is a missing value

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_double_legal_(global_function)
*/
BOOL	is_double_legal(double *pr);


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_missing_value_(global_function)
*/
double get_missing_value(int nOption =0);


// Comments last updated by Frank on 08/24/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_error_code_(global_function)
*/
int get_error_code();

// Comments last updated by Frank on 08/24/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:mod_(global_function)
*/
long mod( long x, long y );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Mod2_(global_function)
*/
int mod2( int x, int y );  ///  Jacky 7/1/2010 ORG-424 ADD_LABMATH_FUNC_INT2_AND_MOD2  

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:nint_(global_function)
*/
int nint( double x );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:nint2_(global_function)
*/
int nint2(double x);		///  Jacky 7/1/2010 ORG-424 ADD_LABMATH_FUNC_INT2_AND_MOD2

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:angle_(global_function)
*/
double angle( double x, double y);

// Comments last updated by Frank on 08/08/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:rmod_(global_function)
*/
double rmod( double x, double y ); 

/**@ >Math Functions>Special Functions */

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gammaln_(global_function)
*/
double gammaln( double x );


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:beta_(global_function)
*/
double beta( double a, double b ); 


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Jn_(global_function)
*/
double Jn( double x, int n ); 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:J0_(global_function)
*/
double J0( double x );			 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:J1_(global_function)
*/
double J1( double x );			 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Yn_(global_function)
*/
double Yn( double x, int n);	 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Y0_(global_function)
*/
double Y0( double x );			 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Y1_(global_function)
*/
double Y1( double x );			

/**@ >Math Functions>Trigonometric */

// Comments last updated by Arvin on 06/15/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:acos_(global_function)
*/
double	acos(double x);

// Comments last updated by Arvin on 06/15/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:asin_(global_function)
*/
double	asin(double x);


/**@ >Math Functions>Exponential */
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:exp_(global_function)
*/
double	exp(double x);


// Comments last updated by Frank on 08/24/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:log_(global_function)
*/
double	log(double x); 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ln_(global_function)
*/
double	ln(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:log10_(global_function)
*/
double	log10(double x); // log base 10; see log or ln functions for log base e

// Comments last updated by Frank on 08/08/2005

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sqrt_(global_function)
*/
double	sqrt(double x);

// Comments last updated by Frank on 08/08/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:_hypot_(global_function)
*/
double	_hypot(double x, double y);

/**@ >Math Functions>Trigonometric */

// the following functions will leading to INF.
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cosh_(global_function)
*/
double	cosh(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sinh_(global_function)
*/
double	sinh(double x);


// Comments last updated by Arvin on 06/15/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tan_(global_function)
*/
double	tan(double x);


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fabs_(global_function)
*/
double	fabs(double x);

// Comments last updated by Frank on 08/08/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_equal_(global_function)
*/
BOOL is_equal(double x, double y, int nCode='=');


/**@ >Math Functions>Rounding and Precision */
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ceil_(global_function)
*/
double	ceil( double x );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:floor_(global_function)
*/
double	floor( double x );



// Comments last updated by Frank on 08/08/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:round_(global_function)
*/
double round( double x, UINT nDecimalPlaces );	// force given value to be nDecimalPlaces

// the following are from Ok70.dll
#pragma dll(@OK)

// Comments last updated by Frank on 08/08/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:prec_(global_function)
*/
double prec(double x, int nSignificantDigits);

// Comments last updated by Frank on 08/08/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_numeric_(global_function)
*/
BOOL is_numeric(LPCSTR lpcstr, BOOL bThousoudSeparatorOK = TRUE, BOOL bLeadZeroOK = TRUE, BOOL bIgnoreRegionalNumeric=false);

#include <msmath.h>


#endif  //_MATH_H

